#include "../SDK/foobar2000.h"
#include "../helpers/helpers.h"
#include "../helpers/wildcard.h"
#include "resource.h"

using namespace pfc;

#define INFO_BUFFER_SIZE 32767
//#include <string>

// {3ED0F151-D407-461e-8B34-51519C8EF84A}
static const GUID cfg_update_perc_guid = 
{ 0x3ed0f152, 0xd407, 0x461e, { 0x8b, 0x34, 0x51, 0x51, 0x9c, 0x8e, 0xf8, 0x4a } };
// {06BACB64-9F15-4da7-A9D2-628E2B1F7DBD}
static const GUID cfg_skip_nondb_guid = 
{ 0x6bacb65, 0x9f15, 0x4da7, { 0xa9, 0xd2, 0x62, 0x8e, 0x2b, 0x1f, 0x7d, 0xbd } };
// {0F16E781-B53C-4720-BBBC-FF3A059F93A4}
static const GUID cfg_write_first_guid = 
{ 0xf16e782, 0xb53c, 0x4720, { 0xbb, 0xbc, 0xff, 0x3a, 0x5, 0x9f, 0x93, 0xa4 } };
// {6BA2279C-D12B-40fe-B579-A7B8791FFA8B}
static const GUID cfg_write_last_guid = 
{ 0x6ba2279d, 0xd12b, 0x40fe, { 0xb5, 0x79, 0xa7, 0xb8, 0x79, 0x1f, 0xfa, 0x8b } };
// {06E2ACA7-18F2-434c-9E33-6070C1264D4E}
static const GUID cfg_write_count_guid = 
{ 0x6e2aca8, 0x18f2, 0x434c, { 0x9e, 0x33, 0x60, 0x70, 0xc1, 0x26, 0x4d, 0x4e } };
// {843A5D37-6846-47ae-923D-3499068D0212}
static const GUID cfg_write_user_guid = 
{ 0x843a5d38, 0x6846, 0x47ae, { 0x92, 0x3d, 0x34, 0x99, 0x6, 0x8d, 0x2, 0x12 } };
// {F327DCA7-B7F2-417b-B4EE-60AE63208472}
//static const GUID cfg_remove_tags_guid = 
//{ 0xa422a1e8, 0x8c96, 0x428d, { 0xaa, 0x4a, 0x3c, 0x18, 0x51, 0xbe, 0x9, 0xea } };
// {422E4255-A481-4a06-885D-8FAB9CF37FF1}
static const GUID cfg_seconds_guid = 
{ 0x422e4256, 0xa481, 0x4a06, { 0x88, 0x5d, 0x8f, 0xab, 0x9c, 0xf3, 0x7f, 0xf1 } };
// {8B4FFD5C-2A4D-46f6-A0FA-C5E5C968CE3D}
static const GUID cfg_skip_files_db_guid = 
{ 0x8b4ffd5d, 0x2a4d, 0x46f6, { 0xa0, 0xfa, 0xc5, 0xe5, 0xc9, 0x68, 0xce, 0x3d } };
static const GUID cfg_skip_files_no_db_guid = 
{ 0x7a446b6c, 0x294d, 0x84f6, { 0x50, 0xfc, 0xa5, 0xb6, 0x42, 0x9c, 0x4a, 0xd3 } };
// {C75646D4-8EE4-43d2-A217-17A6990BF318}
static const GUID cfg_write_append_guid = 
{ 0xc75646d5, 0x8ee4, 0x43d2, { 0xa2, 0x17, 0x17, 0xa6, 0x99, 0xb, 0xf3, 0x18 } };
// {DC77184B-C67C-4a6e-B3F3-F2D529DC8FF0}
static const GUID cfg_last_played_guid = 
{ 0xdc77184c, 0xc67c, 0x4a6e, { 0xb3, 0xf3, 0xf2, 0xd5, 0x29, 0xdc, 0x8f, 0xf0 } };
// {E4AA3455-9666-4b4a-ABD6-F111988ECE6F}
static const GUID cfg_unofficial_tags_guid = 
{ 0xe4aa3456, 0x9666, 0x4b4a, { 0xab, 0xd6, 0xf1, 0x11, 0x98, 0x8e, 0xce, 0x6f } };
static const GUID cfg_official_tags_guid = 
{ 0xf327dca9, 0xb7f2, 0x417b, { 0xb4, 0xee, 0x60, 0xae, 0x63, 0x20, 0x84, 0x72 } };
// {08B4D030-1A72-4ac5-8972-BEEBD7C8A867}
static const GUID cfg_debug_guid = 
{ 0x8b4d031, 0x1a72, 0x4ac5, { 0x89, 0x72, 0xbe, 0xeb, 0xd7, 0xc8, 0xa8, 0x67 } };
// {08B4D030-1A72-4ac5-8972-BEEBD7C8A867}
//static const GUID cfg_edit_disabled_guid = 
//{ 0x8b5a931, 0x2172, 0x46c5, { 0x09, 0xc2, 0x5e, 0xeb, 0xd8, 0xa8, 0xb8, 0x17 } };


static cfg_int cfg_update_perc(cfg_update_perc_guid,50);

static cfg_bool cfg_skip_nondb(cfg_skip_nondb_guid,true),
	cfg_write_first(cfg_write_first_guid,true),
	cfg_write_last(cfg_write_last_guid,true),
	cfg_write_count(cfg_write_count_guid,true),
//	cfg_write_user(cfg_write_user_guid,true), // unused?
//	cfg_write_play_stamp(cfg_write_play_stamp_guid,false),
//	cfg_remove_tags(cfg_remove_tags_guid,true),
	cfg_unofficial_tags(cfg_unofficial_tags_guid,true),
	cfg_official_tags(cfg_official_tags_guid,false),
	cfg_debug(cfg_debug_guid,false);
//	cfg_edit_disabled(cfg_edit_disabled_guid,true);

static cfg_uint cfg_seconds(cfg_seconds_guid,0);

static cfg_string
	cfg_skip_files_no_db(cfg_skip_files_no_db_guid,"*.wav"),
	cfg_skip_files_db(cfg_skip_files_db_guid,"*.wav"),
	cfg_write_append(cfg_write_append_guid,"");


class playcount_state : public bit_array_bittable
{
private:
	unsigned len;

public:
	explicit inline playcount_state():bit_array_bittable(0),len(0){}

	void get_data_raw(stream_writer * p_stream,abort_callback & p_abort)
	{
		if ( len == 0 ) return;

		p_stream->write_lendian_t((DWORD)len, p_abort);

		char c=0;
		int bit=0;
		for(unsigned i=0;i<len;i++)
		{
			bool b = this->get(i);
			c |= b << bit++;
			if (bit==8)
			{
				p_stream->write(&c, 1, p_abort);
				bit = c = 0;
			}
		}
		if (c)
			p_stream->write(&c, 1, p_abort);
	}

	void set_data_raw(stream_reader * p_stream,t_size p_sizehint,abort_callback & p_abort)
	{
		if (p_sizehint < sizeof(DWORD)) return;
		
		DWORD d;
		p_stream->read_lendian_t(d, p_abort);
		unsigned count = (unsigned)d;

		unsigned blen = (count + 7)/8;
		if (p_sizehint < sizeof(DWORD) + blen) return;

		this->init(count);
		unsigned sec = 0;
		for(unsigned i=0;i<blen;i++)
		{
			BYTE b;
			p_stream->read(&b, 1, p_abort);

			for(unsigned bit=0;bit<8;bit++)
			{
				bool set = (b>>bit)&0x1;
				if (set)
					this->set(sec,true);
				sec++;
			}
		}
	}

	void set_table(playcount_state &table)
	{
		this->init(table.get_count());
		for(unsigned i = 0;i<len;i++)
			this->set(i,table.get(i));
	}

	void get_table(playcount_state &out_table)
	{
		out_table.init(len);

		if (len)
		{
			for(unsigned i=0;i<len;i++)
				out_table.set(i,this->get(i));
		}
	}

	void init(unsigned count)
	{
		this->resize(count);
		len = count;
	}

	void clear()
	{
		this->resize(0);
		len = 0;
	}

	unsigned get_count(){ return len; }
};


static playcount_state g_played;

// These store the playing state across restarts
//static cfg_playcount_bittable cfg_last_played(cfg_last_played_guid);
//static cfg_string cfg_last_path(cfg_last_path_guid,"");


static const char g_format_help[] = 
"Timestamp format:\n"
"\n"
"Date specifiers:\n"
"\t%D = day (01-31)\n"
"\t%d = day (1-31)\n"
"\t%W = day of the week, starting from Sunday (1-7)\n"
"\t%M = month (01-12)\n"
"\t%m = month (1-12)\n"
"\t%Y = 4-digit year, including century\n"
"\t%y = 2-digit year, excluding century (00-99)\n"
"\t%j = Julian Date (without fraction)\n"
"\t%J = Julian Date\n\n"
"Time specifiers:\n"
"\t$H = hour (01-23)\n"
"\t$h = hour (1-23)\n"
"\t$M = minute (01-59)\n"
"\t$m = minute (1-59)\n"
"\t$S = second (00-59)\n"
"\t$T = offset from local to UTC\n\n"
"Other specifiers:\n"
"\t#U = name of the current user\n"
"\t#C = name of the current computer\n\n"
"All times are local.";




// modified from http://aa.usno.navy.mil/data/docs/JulianDate.html
double dateToJulian(SYSTEMTIME *st)
{
	double jy, ja, jm;

	if(st->wYear==0)
	{
		//alert("There is no year 0 in the Julian system!");
		return -1;
	}

	// check for invalid date within date change - disabled for now...
	// not likely to happen in foobar.
	//if( st->wYear == 1582 && st->wMonth == 10 && st->wDay > 4 && st->wDay < 15)
	//	return -1;

	int year = st->wYear;

	// also disabling CE vs. BCE handling... again, not likely to happen
	//if( !date.ce ) 
	//	year = -year + 1;

	if( st->wMonth > 2 ) 
	{
		jy = year;
		jm = st->wMonth + 1;
	} 
	else 
	{
		jy = year - 1;
		jm = st->wMonth + 13;
	}

	double intgr = floor( floor(365.25*jy) + floor(30.6001*jm) + st->wDay + 1720995 );

	//check for switch to Gregorian calendar
	double gregcal = 15 + 31*( 10 + 12*1582 );
	if( st->wDay + 31*(st->wMonth + 12*year) >= gregcal ) 
	{
		ja = floor(0.01*jy);
		intgr += 2 - ja + floor(0.25*ja);
	}

	//correct for half-day offset
	double dayfrac = st->wHour/24.0 - 0.5;
	if( dayfrac < 0.0 ) 
	{
		dayfrac += 1.0;
		--intgr;
	}

	//now set the fraction of a day
	dayfrac = dayfrac + (st->wMinute + st->wSecond/60.0)/60.0/24.0;

	return intgr + dayfrac;
}

static string8 format(SYSTEMTIME *st, const char *format)
{
	string8 result("");
	char temp[32];
	int len=strlen(format);

	for (int i=0;i<len;i++)
	{
		char c = format[i];
		if ( c != '%' && c != '$' && c != '#' )
			result.add_char(c);
		else if (c == '%')
		{
			i++;
			switch(format[i])
			{
			case 'm':
				sprintf(temp,"%d",st->wMonth);
				result.add_string(temp);
				break;
			case 'M':
				sprintf(temp,"%02d",st->wMonth);
				result.add_string(temp);
				break;
			case 'd':
				sprintf(temp,"%d",st->wDay);
				result.add_string(temp);
				break;
			case 'D':
				sprintf(temp,"%02d",st->wDay);
				result.add_string(temp);
				break;
			case 'W':
				sprintf(temp,"%d",st->wDayOfWeek+1);
				result.add_string(temp);
				break;
			case 'y':
				sprintf(temp,"%02d",st->wYear-2000);
				result.add_string(temp);
				break;
			case 'Y':
				sprintf(temp,"%04d",st->wYear);
				result.add_string(temp);
				break;
			case 'j':
				{
					ULONG j = ( ULONG ) dateToJulian(st);
					sprintf(temp,"%ld",j);
					result.add_string(temp);
				}
				break;
			case 'J':
				sprintf(temp,"%f",dateToJulian(st));
				result.add_string(temp);
				break;
			}
		}
		else if (c == '$')
		{
			i++;
			switch(format[i])
			{
			case 'h':
				sprintf(temp,"%d",st->wHour);
				result.add_string(temp);
				break;
			case 'H':
				sprintf(temp,"%02d",st->wHour);
				result.add_string(temp);
				break;
			case 'm':
				sprintf(temp,"%d",st->wMinute);
				result.add_string(temp);
				break;
			case 'M':
				sprintf(temp,"%02d",st->wMinute);
				result.add_string(temp);
				break;
			case 's':
				sprintf(temp,"%d",st->wSecond);
				result.add_string(temp);
				break;
			case 'S':
				sprintf(temp,"%02d",st->wSecond);
				result.add_string(temp);
				break;
			case 't':
			case 'T':
				{
					TIME_ZONE_INFORMATION tz;
					tz.Bias = 0;
					GetTimeZoneInformation(&tz);
					sprintf(temp,"%s%02d:%02d",tz.Bias<0?"-":"+",labs(tz.Bias)/60,labs(tz.Bias)%60);
					result.add_string(temp);
				}
				break;
			case 'j':
				{
					ULONG j = ( ULONG ) dateToJulian(st);
					sprintf(temp,"%ld",j);
					result.add_string(temp);
				}
				break;
			case 'J':
				sprintf(temp,"%f",dateToJulian(st));
				result.add_string(temp);
				break;
			}
		}
		else if (c == '#')
		{
			i++;
			switch(format[i])
			{
			case 'U':
				{
				string8 val;
				TCHAR  infoBuf[INFO_BUFFER_SIZE];
				DWORD  bufCharCount = INFO_BUFFER_SIZE;
				bufCharCount = INFO_BUFFER_SIZE;

				if( GetUserName( infoBuf, &bufCharCount ) )
				{
					val = stringcvt::string_utf8_from_wide(infoBuf) ;
				}
				result.add_string(val);
				}
				break;
			case 'C':
				{
				string8 val;
				TCHAR  infoBuf[INFO_BUFFER_SIZE];
				DWORD  bufCharCount = INFO_BUFFER_SIZE;
				bufCharCount = INFO_BUFFER_SIZE;

				if( GetComputerName( infoBuf, &bufCharCount ) )
				{
					val = stringcvt::string_utf8_from_wide(infoBuf) ;
				}
				result.add_string(val);
				}
				break;
			}
		}
	}

	return result;
}

class config_playcount : public preferences_page
{
private:
	static BOOL CALLBACK DialogProc(HWND wnd,UINT msg,WPARAM wp,LPARAM lp)
	{
		switch(msg)
		{
		case WM_INITDIALOG:
			uSetDlgItemText(wnd,IDC_SKIP_NO_DB,cfg_skip_files_no_db);
			uSetDlgItemText(wnd,IDC_SKIP_DB,cfg_skip_files_db);
			uSetDlgItemText(wnd,IDC_APPEND,cfg_write_append);
			uSetDlgItemInt(wnd,IDC_SECONDS,cfg_seconds,0);

			uSendDlgItemMessage(wnd,IDC_UPDATE_PERC,TBM_SETRANGE,0,MAKELONG(0,100));
			uSendDlgItemMessage(wnd,IDC_UPDATE_PERC,TBM_SETPOS,1,cfg_update_perc);
			uSetDlgItemText(wnd,IDC_PERC_STATUS,string8(format_uint(cfg_update_perc)) << "%");

			uSendDlgItemMessage(wnd,IDC_SKIP_NONDB,BM_SETCHECK,cfg_skip_nondb,0);
			uSendDlgItemMessage(wnd,IDC_FIRST_PLAYED,BM_SETCHECK,cfg_write_first,0);
			uSendDlgItemMessage(wnd,IDC_LAST_PLAYED,BM_SETCHECK,cfg_write_last,0);
			uSendDlgItemMessage(wnd,IDC_COUNT,BM_SETCHECK,cfg_write_count,0);
			//uSendDlgItemMessage(wnd,IDC_PLAY_STAMP,BM_SETCHECK,cfg_write_play_stamp,0);
			//uSendDlgItemMessage(wnd,IDC_REMOVE,BM_SETCHECK,cfg_remove_tags,0);
			uSendDlgItemMessage(wnd,IDC_RADIO1,BM_SETCHECK,cfg_unofficial_tags,0);
			uSendDlgItemMessage(wnd,IDC_RADIO2,BM_SETCHECK,cfg_official_tags,0);
			uSendDlgItemMessage(wnd,IDC_DEBUG,BM_SETCHECK,cfg_debug,0);
			//uSendDlgItemMessage(wnd,IDC_SKIP_NO_DB,ES_READONLY,cfg_edit_disabled,0);

			return 1;
		case WM_COMMAND:
			switch(wp)
			{
			case IDC_MANUAL:
				uMessageBox(wnd,g_format_help,"Help",0);
				break;
			case (EN_CHANGE<<16)|IDC_SKIP_NO_DB:
				cfg_skip_files_no_db = string_utf8_from_window((HWND)lp);
				break;
			case (EN_CHANGE<<16)|IDC_SKIP_DB:
				cfg_skip_files_db = string_utf8_from_window((HWND)lp);
				break;				
			case (EN_CHANGE<<16)|IDC_APPEND:
				cfg_write_append = string_utf8_from_window((HWND)lp);
				break;
			case (EN_CHANGE<<16)|IDC_SECONDS:
				BOOL result;
				if ( true )
				{	unsigned temp_seconds = GetDlgItemInt(wnd, IDC_SECONDS, &result, FALSE);
					if ( result )
						cfg_seconds = temp_seconds;
				}
				break;
			case IDC_SKIP_NONDB:
				cfg_skip_nondb = !!uSendMessage(uGetDlgItem(wnd,IDC_SKIP_NONDB),BM_GETCHECK,0,0);
				//cfg_edit_disabled = !!uSendMessage(uGetDlgItem(wnd,IDC_SKIP_NO_DB),ES_READONLY,0,0);
				break;
			case IDC_COUNT:
				cfg_write_count = !!uSendMessage(uGetDlgItem(wnd,IDC_COUNT),BM_GETCHECK,0,0);
				break;
			case IDC_FIRST_PLAYED:
				cfg_write_first = !!uSendMessage(uGetDlgItem(wnd,IDC_FIRST_PLAYED),BM_GETCHECK,0,0);
				break;
			case IDC_LAST_PLAYED:
				cfg_write_last = !!uSendMessage(uGetDlgItem(wnd,IDC_LAST_PLAYED),BM_GETCHECK,0,0);
				break;
			//case IDC_REMOVE:
			//	cfg_remove_tags = !!uSendMessage(uGetDlgItem(wnd,IDC_REMOVE),BM_GETCHECK,0,0);
			//	break;
			case IDC_RADIO1:
				cfg_unofficial_tags = !!uSendMessage(uGetDlgItem(wnd,IDC_RADIO1),BM_GETCHECK,0,0);
				cfg_official_tags = !!uSendMessage(uGetDlgItem(wnd,IDC_RADIO2),BM_GETCHECK,0,0);
				break;
			case IDC_RADIO2:
				cfg_official_tags = !!uSendMessage(uGetDlgItem(wnd,IDC_RADIO2),BM_GETCHECK,0,0);
				cfg_unofficial_tags = !!uSendMessage(uGetDlgItem(wnd,IDC_RADIO1),BM_GETCHECK,0,0);
				break;
			case IDC_DEBUG:
				cfg_debug = !!uSendMessage(uGetDlgItem(wnd,IDC_DEBUG),BM_GETCHECK,0,0);
				break;
			}
			break;

		case WM_HSCROLL:
			switch(uGetWindowLong((HWND)lp,GWL_ID))
			{
			case IDC_UPDATE_PERC:
				cfg_update_perc = uSendMessage((HWND)lp,TBM_GETPOS,0,0);
				uSetDlgItemText(wnd,IDC_PERC_STATUS,string8(format_uint(cfg_update_perc)) << "%");
				break;
			}
			break;
		}
		return 0;
	}
public:
	HWND create(HWND parent)
	{
		return uCreateDialog(IDD_PLAYCOUNT_MOD_CONFIG,parent,DialogProc);
	}

	const char * get_name() {return "Play Count Mod";}
	GUID get_guid()
	{
		// {F5C3FAB8-50AD-4e93-8C3E-194AB3BD93F6}
		static const GUID guid =
		{ 0xf5c3fab8, 0x50ad, 0x4e93, { 0x8c, 0x3e, 0x19, 0x4a, 0xb3, 0xbd, 0x93, 0xf6 } };
		return guid;
	}
	GUID get_parent_guid() {return guid_tools;}
	bool reset_query() {return false;}
	void reset() {}
	bool get_help_url(pfc::string_base & p_out) {return false;}
};

static preferences_page_factory_t<config_playcount> playconf;

static metadb_handle_ptr _current;

class FileInfoData : public file_info_filter {

private:
    string8 tag, val;
	bool remove;

public:

    FileInfoData(const char* _tag, const char* _val, bool _remove) : tag(_tag), val(_val), remove(_remove) {}

    virtual bool apply_filter(metadb_handle_ptr p_location,t_filestats p_stats,file_info & p_info) {

		if (remove) p_info.meta_remove_field(tag);
		else p_info.meta_set(tag,val);
        return true;
    }

};


class update_info_callback : public main_thread_callback
{
private:
	SYSTEMTIME _st;
	bool resuming;

public:


	bool shutting_down;

	update_info_callback(SYSTEMTIME st, bool res) {
		_st = st;
		resuming = res;
		shutting_down = false;
	}

    virtual void callback_run()
    {

		if (!updateInfo() && shutting_down) {
			// save the current played amount and length
			if (cfg_debug)
			{
				unsigned secsPlayed = g_played.calc_count(true,0,g_played.get_count());
				console::info(string8("Playcount saving for restart, ") << secsPlayed << " seconds played");
			}

			string8 path(core_api::get_profile_path());
			path += "\\playcount_state.cfg";

			service_ptr_t<file> statefile;
			abort_callback_impl abort;
			try
			{
				filesystem::g_open(statefile, path, filesystem::open_mode_write_new, abort);
				statefile->write_string(_current->get_path(), abort);
				g_played.get_data_raw(statefile.get_ptr(), abort);
				statefile.release();
				if (cfg_debug)
					console::info("Successfully wrote playcount state file");
			}
			catch (...)
			{
				console::warning("Unable to write playcount state file");
			}
		}

	//	_current.release();
		return;
	}

	// this is my somewhat lame attempt (hack) at avoiding warnings in
	// the console (and the subsequent console pop-up if configured) when
	// and update is attempt on a WAV file (and who knows what else).
	// ideally, there should be a way for me to know if a format supports
	// tags, or at the very least make the console silent.
	//
	// 0 = file + db
	// -1 = none
	// 1 = db only
	static inline int update_mode(metadb_handle_ptr track)
	{
		// ignore files not in the db
		if (cfg_skip_nondb && !static_api_ptr_t<library_manager>()->is_item_in_library(track))
			return -1;

		// files matching a pattern are skipped for the file update... DB
		if (wildcard_helper::test_path(track->get_path(),cfg_skip_files_db,true) && static_api_ptr_t<library_manager>()->is_item_in_library(track))
			return 1;

		// files matching a pattern are skipped for the file update... not in DB
		if (wildcard_helper::test_path(track->metadb_handle::get_path(),cfg_skip_files_no_db,true) && !static_api_ptr_t<library_manager>()->is_item_in_library(track))
			return 2;		
		

		return 0;
	}

	static inline bool has_played(unsigned played, unsigned len, unsigned perc)
	{
		if ( len <= cfg_seconds )
			return true;
		if (len==0)
			return true;
		return ((played*100)/len) >= perc;
	}

	bool updateInfo() {

		if (_current.is_empty()) {
			return true;
		}

		unsigned secsPlayed = g_played.calc_count(true,0,g_played.get_count());

		if (!has_played(secsPlayed,g_played.get_count(),cfg_update_perc))
			return false;

		int upd_mode = update_mode(_current);
		if (!(upd_mode == 0) ||
			!(cfg_write_first||cfg_write_last||cfg_write_count))
		{
			_current.release();
			return true;
		}

		static_api_ptr_t<metadb_io> mdbio;
		if (mdbio->load_info(_current, metadb_io::load_info_default, core_api::get_main_window(), cfg_debug) != metadb_io::load_info_success)
		{
			if (cfg_debug)
				console::warning("Couldn't update playcount info: load_info failed");
			return false;
		}
		file_info_impl info;
		if (!_current->get_info(info))
		{
			if (cfg_debug)
				console::warning("Couldn't update playcount info: get_info failed");
			return false;
		}
		
		
		
		// update play_counter
		if ( cfg_write_count )
		{
			const char *count_str_old = info.meta_get("PLAY_COUNT",0);
			const char *count_str = info.meta_get("PLAY_COUNTER",0);
			const char *tagname;
			const char *tagname_old;
			char val_tmp[32];
			string8 value("");
			int count;
			
			if ( cfg_unofficial_tags ) //Playcount_mod tags
			{
				if ( count_str )
				{
				count = atoi(count_str) + 1;
				}
				else if (count_str_old)
				{
				count = atoi(count_str_old) + 1;
				}
				else
				{
				count = 1;
				}
			tagname = "PLAY_COUNTER";
			tagname_old = "PLAY_COUNT";
			}
			else //Playback statistics tags
			{
				if ( count_str_old )
				{
				count = atoi(count_str_old) + 1;
				}
				else if (count_str)
				{
				count = atoi(count_str) + 1;
				}
				else
				{
				count = 1;
				}			
			tagname = "PLAY_COUNT";
			tagname_old = "PLAY_COUNTER";
			}		
			_itoa(count,val_tmp,10);
			value.add_string(val_tmp);
			
			service_ptr_t<FileInfoData> info = new service_impl_t<FileInfoData>(tagname,value,false);
			static_api_ptr_t<metadb_io_v2>()->update_info_async(pfc::list_single_ref_t<metadb_handle_ptr>(_current), info, core_api::get_main_window(), metadb_io_v2::op_flag_delay_ui, NULL);
			Sleep(500);
			if (tagname_old)
			{			
			service_ptr_t<FileInfoData> info = new service_impl_t<FileInfoData>(tagname_old,"",true);
			static_api_ptr_t<metadb_io_v2>()->update_info_async(pfc::list_single_ref_t<metadb_handle_ptr>(_current), info, core_api::get_main_window(), metadb_io_v2::op_flag_delay_ui, NULL);	
			Sleep(500);
			}
			
		}


		
		// write first_played tag
		if ( cfg_write_first )
		{
			const char *tagname;
			const char *tagname_old;
			char val_tmp[32];
			FILETIME ft_tmp;
			SYSTEMTIME st_tmp;
			string8 value("");
			bool updating = false;			
			
			
			if ( cfg_unofficial_tags ) //Playcount_mod tags
			{			
				if (info.meta_get_count_by_name("FIRST_PLAYED") == 0)
				{
					if (info.meta_get_count_by_name("FIRST_PLAYED_TIMESTAMP") == 0)	//first time played
					{
						value = format(&_st, "%Y-%M-%D $H:$M:$S ");
						if ( !cfg_write_append.is_empty() )
						{
								value += format(&_st, cfg_write_append);
						}
					}
					else //convert timestamp to first_played
					{
						ft_tmp.dwLowDateTime  = (DWORD) (_atoi64(info.meta_get("FIRST_PLAYED_TIMESTAMP",0)) & 0xFFFFFFFF );
						ft_tmp.dwHighDateTime = (DWORD) (_atoi64(info.meta_get("FIRST_PLAYED_TIMESTAMP",0)) >> 32 );
						FileTimeToSystemTime (&ft_tmp,&st_tmp);
						value = format(&st_tmp, "%Y-%M-%D $H:$M:$S ");
						if ( !cfg_write_append.is_empty() )
						{
								value += format(&st_tmp, cfg_write_append);
						}					
					}			
				updating = true;			
				}
			tagname = "FIRST_PLAYED";
			tagname_old = "FIRST_PLAYED_TIMESTAMP";	
			}
			else	//Playback statistics tags
			{
				if (info.meta_get_count_by_name("FIRST_PLAYED_TIMESTAMP") == 0)
				{
					if (info.meta_get_count_by_name("FIRST_PLAYED") == 0) 	//first time played
					{
						GetLocalTime(&st_tmp);
						SystemTimeToFileTime(&st_tmp, &ft_tmp);
						ULARGE_INTEGER time_tmp = *(ULARGE_INTEGER*)&ft_tmp;
						__int64 i64time_tmp = *(__int64 *)&time_tmp;
						_i64toa(i64time_tmp,val_tmp,10);	
						value.add_string(val_tmp);					
					}
					else	//convert FIRST_PLAYED to TIMESTAMP
					{
						char str_tmp1[40];
						char str_tmp2[4];
						char str_tmp3[2];
						strcpy (str_tmp1,info.meta_get("FIRST_PLAYED",0));
						GetSystemTime(&st_tmp);
						
						memmove (str_tmp2,str_tmp1,4);
						st_tmp.wYear = atoi(str_tmp2);
						
						memmove (str_tmp3,str_tmp1+5,2);
						st_tmp.wMonth = atoi(str_tmp3);
						
						memmove (str_tmp3,str_tmp1+8,2);
						st_tmp.wDay = atoi(str_tmp3);
						
						memmove (str_tmp3,str_tmp1+11,2);
						st_tmp.wHour = atoi(str_tmp3);
						
						memmove (str_tmp3,str_tmp1+14,2);
						st_tmp.wMinute = atoi(str_tmp3);
						
						memmove (str_tmp3,str_tmp1+17,2);
						st_tmp.wSecond = atoi(str_tmp3);
						
						SystemTimeToFileTime(&st_tmp, &ft_tmp);
						ULARGE_INTEGER time_tmp = *(ULARGE_INTEGER*)&ft_tmp;
						__int64 i64time_tmp = *(__int64 *)&time_tmp;	
						_i64toa(i64time_tmp,val_tmp,10);	
						value.add_string(val_tmp);	
					}					
				updating = true;	
				}
			tagname = "FIRST_PLAYED_TIMESTAMP";
			tagname_old = "FIRST_PLAYED";			
			}			
			
			if (updating)
			{	
			service_ptr_t<FileInfoData> info = new service_impl_t<FileInfoData>(tagname,value,false);
			static_api_ptr_t<metadb_io_v2>()->update_info_async(pfc::list_single_ref_t<metadb_handle_ptr>(_current), info, core_api::get_main_window(), metadb_io_v2::op_flag_delay_ui, NULL);
			Sleep(500);
			}
			
			if (tagname_old)
			{
			service_ptr_t<FileInfoData> info = new service_impl_t<FileInfoData>(tagname_old,"",true);
			static_api_ptr_t<metadb_io_v2>()->update_info_async(pfc::list_single_ref_t<metadb_handle_ptr>(_current), info, core_api::get_main_window(), metadb_io_v2::op_flag_delay_ui, NULL);	
			Sleep(500);
			}			
		}


		
		
		// update last_played tag
		if ( cfg_write_last )
		{
			const char *tagname;
			const char *tagname_old;
			char val_tmp[32];
			FILETIME ft_tmp;
			SYSTEMTIME st_tmp;			
			string8 value("");
			
			if ( cfg_unofficial_tags )		//playcount_mod tags
			{
				value = format(&_st, "%Y-%M-%D $H:$M:$S ");				
				if ( !cfg_write_append.is_empty() && !value.is_empty() )
				{
						value += format(&_st, cfg_write_append);
				}
			tagname = "LAST_PLAYED";
			tagname_old = "LAST_PLAYED_TIMESTAMP";			
			}
			else			//playback statistics tags
			{	
				GetLocalTime(&st_tmp);
				SystemTimeToFileTime(&st_tmp, &ft_tmp);
				ULARGE_INTEGER time_tmp = *(ULARGE_INTEGER*)&ft_tmp;
				__int64 i64time_tmp = *(__int64 *)&time_tmp;
				_i64toa(i64time_tmp,val_tmp,10);	
				value.add_string(val_tmp);
				
			tagname = "LAST_PLAYED_TIMESTAMP";
			tagname_old = "LAST_PLAYED";	
			}

			service_ptr_t<FileInfoData> info = new service_impl_t<FileInfoData>(tagname,value,false);
			static_api_ptr_t<metadb_io_v2>()->update_info_async(pfc::list_single_ref_t<metadb_handle_ptr>(_current), info, core_api::get_main_window(), metadb_io_v2::op_flag_delay_ui, NULL);		
			Sleep(500);
			//console::info("Updated LAST_PLAYED.");					
			
			if (tagname_old)
			{			
			service_ptr_t<FileInfoData> info = new service_impl_t<FileInfoData>(tagname_old,"",true);
			static_api_ptr_t<metadb_io_v2>()->update_info_async(pfc::list_single_ref_t<metadb_handle_ptr>(_current), info, core_api::get_main_window(), metadb_io_v2::op_flag_delay_ui, NULL);		
			}
		}
		
		

		// remove old tags
//		if ( cfg_remove_tags )
//		{
//			service_ptr_t<FileInfoData> info = new service_impl_t<FileInfoData>("PLAY_DATE","");
//			static_api_ptr_t<metadb_io_v2>()->update_info_async(pfc::list_single_ref_t<metadb_handle_ptr>(_current), info, core_api::get_main_window(), metadb_io_v2::op_flag_delay_ui, NULL);		
			//info.meta_remove_field("PLAY_DATE");
			//info.meta_remove_field("PLAY_TIME");
//			console::info("Info9.");
//		}
	
		
		bool retval = true;
		//if (mdbio->update_info(_current, info, core_api::get_main_window(), cfg_debug) != metadb_io::update_info_success)
		//{
		//	if (cfg_debug)
		//		console::error("Error writing DB/file info.");
		//	retval = false;
		//}
		//else if (cfg_debug)
		//	console::info("Successfully updated playcount info.");
		//
		_current.release();
		return retval;

	}

	
};


class playcounter : public play_callback_static
{
private:
//	metadb_handle_ptr _current;
	SYSTEMTIME _st;
	bool resuming;

	void update_info()
	{
		static_api_ptr_t<main_thread_callback_manager> cm;
		service_ptr_t<update_info_callback> myc = new service_impl_t<update_info_callback>(_st, resuming);
		cm->add_callback(myc);
				
//		return true;
	}

	bool update_info2() {
		static_api_ptr_t<main_thread_callback_manager> cm;
		service_ptr_t<update_info_callback> myc = new service_impl_t<update_info_callback>(_st, resuming);
		myc->shutting_down = true;
		cm->add_callback(myc);
		return true;
	}


public:
	playcounter() :  resuming(false) {_current=NULL;}

	virtual unsigned get_flags() 
	{return flag_on_playback_new_track|flag_on_playback_stop|flag_on_playback_time|flag_on_playback_starting;}

	virtual void on_playback_new_track(metadb_handle_ptr track)
	{
		::GetLocalTime(&_st);
		if (resuming)
		{
			string8 path(core_api::get_profile_path());
			path += "\\playcount_state.cfg";

			service_ptr_t<file> statefile;
			abort_callback_impl abort;
			playcount_state oldstate;
			string8 oldpath;

			try
			{
				filesystem::g_open(statefile, path, filesystem::open_mode_read, abort);
				statefile->read_string(oldpath, abort);
				oldstate.set_data_raw(statefile.get_ptr(), statefile->get_size(abort), abort);
				statefile.release();
				filesystem::g_remove(path, abort);
			}
			catch (...)
			{
				if (cfg_debug)
					console::info("Playcount resuming from restart, track already updated");
				resuming = false;
				_current.release();
				return;
			}

			if (stricmp(oldpath.get_ptr(),track->get_path())==0)
			{
				// resuming from a restart
				oldstate.get_table(g_played);

				if (cfg_debug)
				{
					unsigned secsPlayed = g_played.calc_count(true,0,g_played.get_count());
					console::info(string8("Playcount resuming from restart, ") << secsPlayed << " seconds played");
				}
				
				_current.copy(track);
				update_info();
			}
			else
				console::warning("Playcount resuming from restart, track paths do not match?");
			resuming = false;
		}
		else
		{
			update_info();
			g_played.clear();

			// store current track info
			int len = (int)(track->get_length()-(cfg_update_perc==100?1.0:0.0));
			if (len > 0)
			{
				g_played.init(len);
				_current.copy(track);
			}
		}
	}

	virtual void on_playback_starting(play_control::t_track_command p_command,bool p_paused)
	{
		// Can't do alot here, we don't get a handle until new_track (called after this)
		if (p_command == play_control::track_command_resume)
			resuming = true;
	}

	virtual void on_playback_stop(play_control::t_stop_reason p_reason)
	{
		if (_current.is_empty()) return;
		if (play_control::stop_reason_shutting_down == p_reason) update_info2();
		else update_info();
		_current.release();
	}

	virtual void on_playback_time(double p_time)
	{
		if (_current.is_empty()) return;
		g_played.set((int)p_time-1,true);

		update_info();
	}

	virtual void on_playback_seek(double time) {}
	virtual void on_playback_pause(bool p_state) {}
	virtual void on_playback_edited(metadb_handle_ptr track) {}
	virtual void on_playback_dynamic_info(const file_info & p_info) {};
	virtual void on_playback_dynamic_info_track(const file_info & p_info) {};
	virtual void on_volume_change(float p_new_val) {}
};

static play_callback_static_factory_t<playcounter> blah;


DECLARE_COMPONENT_VERSION("Play Count Mod","1.0.2","Counts the number of times a song has been played.\nAlso stores the date/time of the most recent time the song was played\nand the date/time of the first time the song was played.\n\nBuilt by kl33per\nPorted by G-Lite\nModded by Crusoli");